
/*
 * Primeiro exerccio do Tutorial de J2ME
 *
 * @author Tarcisio Camara
 */


import java.io.IOException;

import java.util.Random;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;


/**
 * Possui as constantes compartilhadas por toda a aplicao
 */
public class Constants {

    /**
     * Constructor
     */
    private Constants() {}

    /** EXIT soft key */
    public static final Command exitCommand =
        new Command("EXIT", Command.EXIT, 2);

    /** PAUSE soft key */
    public static final Command pauseCommand =
        new Command("PAUSE", Command.OK, 1);

    /** RESUME soft key */
    public static final Command resumeCommand =
        new Command("RESUME", Command.OK, 1);

    /** Velocidade vertical da nave */
    public static final short MY_SHIP_VERTICAL_SPEED = 0;

    /** Velocidade horizontal da nave */
    public static final short MY_SHIP_HORIZONTAL_SPEED = 3;

    /** Numero mximo de balas que a nave pode atirar de uma s vez*/
    public static final short NUM_BULLETS = 7;

    /** Imagens da nave */
    public static Image shipImage = null;
    public static final int SHIP_FRAME_WIDTH  = 19;
    public static final int SHIP_FRAME_HEIGHT = 25;
    public static int[] flyShipSequence = {0, 1};
    public static int[] blowShipSequence = {2, 3};
    
    /** Imagens do inimigo*/
    public static Image enemyImage = null;
    public static final int ENEMY_FRAME_WIDTH  = 31;
    public static final int ENEMY_FRAME_HEIGHT = 21;
    public static int[] flyEnemySequence = {0, 1};
    public static int[] blowEnemySequence = {2, 3};

    /** Imagens da bala */
    public static Image bulletImage = null;
    public static final int BULLET_FRAME_WIDTH  = 3;
    public static final int BULLET_FRAME_HEIGHT = 4;
    public static int[] bulletSequence = {0}; // poderia usar sequencia default

    /** Imagem da indicao de vida */
    public static Image lifeImage = null;

    /** Imagem de gameover */
    public static Image gameoverImage = null;

    /** Numero de vidas */
    public static short LIVES = 3;

    /** Fonte usada para escrever na tela */
    public static final Font FONT = Font.getFont(Font.FACE_SYSTEM,
                                        Font.STYLE_PLAIN, Font.SIZE_MEDIUM);

    /** Largura da tela */
    public static int WIDTH;

    /** Altura da tela */
    public static int HEIGHT;
    public static Random random = new Random();

    /**
     * Carrega todas as imagens do jogo
     */
    public static void loadImages() {

        try {
            shipImage      = Image.createImage("/ship.png");
            enemyImage     = Image.createImage("/enemy.png");
            bulletImage    = Image.createImage("/bullet.png");
            lifeImage      = Image.createImage("/life.png");
        } catch(IOException ioe) {
            System.out.println("ERRO: IOException em loadImages()");
            ioe.printStackTrace();
            return;
        }
    }
}
